---
generated_at: 2026-01-22 14:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-Daily Build Group Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/ci/daily_build_group_report_result_service.rb` (行5-12, 16-35, 38-40, 42-45)
- E-02: `app/models/ci/daily_build_group_report_result.rb` (行4-33)
- E-03: 帳票一覧.csv (No.19の定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | データベーステーブルに保存 | E-02 (モデル構造) | ○ |
| C-02 | upsert_reportsでupsert | E-02 (行28-31), E-01 (行6) | ○ |
| C-03 | project_idを保存 | E-01 (行19) | ○ |
| C-04 | ref_pathを保存 | E-01 (行20) | ○ |
| C-05 | dateを保存 | E-01 (行21) | ○ |
| C-06 | group_nameを保存 | E-01 (行29-30) | ○ |
| C-07 | coverageを保存 | E-01 (行31-33) | ○ |
| C-08 | last_pipeline_idを保存 | E-01 (行22) | ○ |
| C-09 | default_branchを保存 | E-01 (行23) | ○ |
| C-10 | group_idを保存 | E-01 (行24) | ○ |
| C-11 | average_coverageで平均計算 | E-01 (行42-45) | ○ |
| C-12 | round(2)で小数点以下2桁 | E-01 (行44) | ○ |
| C-13 | aggregateでgroup_byグルーピング | E-01 (行38-40) | ○ |
| C-14 | builds.with_coverageでフィルタ | E-01 (行28), E-02 (行21) | ○ |
| C-15 | Projects::CiFeatureUsageに記録 | E-01 (行7-10) | ○ |
| C-16 | feature: :code_coverageを記録 | E-01 (行9) | ○ |
| C-17 | belongs_to :last_pipeline | E-02 (行9-10) | ○ |
| C-18 | store_accessor :data, :coverage | E-02 (行26) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目に根拠あり、コードと整合

## 6) レビュアーチェックリスト（最小）
- [ ] パイプライン完了後にデータが保存されることを確認
- [ ] group_nameごとに平均カバレッジが計算されることを確認
- [ ] upsertで既存データが更新されることを確認
- [ ] Projects::CiFeatureUsageに利用状況が記録されることを確認
